/*
 * Decompiled with CFR 0.152.
 */
package orbital.robotic;

import java.awt.Point;
import java.io.Serializable;

public class Position
extends Point
implements Serializable {
    private static final long serialVersionUID = 7705012188222777623L;

    public Position(int x, int y) {
        super(x, y);
    }

    public Position(Position b) {
        super(b);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Position)) {
            return false;
        }
        Position b = (Position)o;
        return this.x == b.x && this.y == b.y;
    }

    public int hashCode() {
        return this.x ^ this.y;
    }

    public void move(Position p) {
        super.move(p.x, p.y);
    }

    public void translate(Position p) {
        super.translate(p.x, p.y);
    }

    public Position add(Position B) {
        return new Position(this.x + B.x, this.y + B.y);
    }

    public Position subtract(Position B) {
        return new Position(this.x - B.x, this.y - B.y);
    }

    public double length() {
        return Math.sqrt((double)this.x * (double)this.x + (double)(this.y * this.y));
    }

    public static boolean isCross(Position d) {
        return Math.abs(d.x) == 0 ^ Math.abs(d.y) == 0;
    }

    public static boolean isDiagonal(Point d) {
        return Math.abs(d.x) == Math.abs(d.y);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.x + '|' + this.y + "]";
    }
}

