/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.awt.Dimension;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import orbital.logic.functor.Function;
import orbital.logic.functor.Functor;
import orbital.logic.functor.Predicate;
import orbital.logic.functor.VoidFunction;
import orbital.math.AlgebraicAlgorithms;
import orbital.math.Arithmetic;
import orbital.math.ArithmeticFormat;
import orbital.math.Complex;
import orbital.math.Euclidean;
import orbital.math.Fraction;
import orbital.math.Integer;
import orbital.math.MathUtilities;
import orbital.math.Matrix;
import orbital.math.Polynomial;
import orbital.math.Quotient;
import orbital.math.Rational;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Symbol;
import orbital.math.Tensor;
import orbital.math.UnivariatePolynomial;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Functions;
import orbital.math.functional.MathFunctor;
import orbital.moon.math.AbstractComplex;
import orbital.moon.math.AbstractFraction;
import orbital.moon.math.AbstractInteger;
import orbital.moon.math.AbstractMultivariatePolynomial;
import orbital.moon.math.AbstractQuotient;
import orbital.moon.math.AbstractRational;
import orbital.moon.math.AbstractReal;
import orbital.moon.math.AbstractSymbol;
import orbital.moon.math.AbstractTensor;
import orbital.moon.math.AbstractValues;
import orbital.moon.math.ArithmeticMatrix;
import orbital.moon.math.ArithmeticMultivariatePolynomial;
import orbital.moon.math.ArithmeticTensor;
import orbital.moon.math.ArithmeticUnivariatePolynomial;
import orbital.moon.math.ArithmeticVector;
import orbital.moon.math.RMatrix;
import orbital.moon.math.RVector;
import orbital.util.Setops;
import orbital.util.Utility;

public class ValuesImpl
extends AbstractValues {
    static final Predicate symbolic;
    private static final int MAX_CONSTANT = 10;
    private static final Integer[] posConst;
    private static final Integer[] negConst;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ValuesImpl() {
        this.initialSetCoercer(new Function(){

            public Object apply(Object o) {
                if (o instanceof Arithmetic[]) {
                    Arithmetic[] operands = (Arithmetic[])o;
                    if (operands.length <= 1) {
                        return operands;
                    }
                    return ValuesImpl.this.minimumCoerced(operands);
                }
                return o;
            }
        });
        this.initialSetNormalizer(orbital.logic.functor.Functions.id);
    }

    public Integer valueOf(int val) {
        if (0 <= val && val <= 10) {
            return posConst[val];
        }
        if (-10 <= val && val < 0) {
            return negConst[-val];
        }
        return new AbstractInteger.Int(val);
    }

    public Integer valueOf(long val) {
        return -10L < val && val < 10L ? this.valueOf((int)val) : new AbstractInteger.Long(val);
    }

    public Integer valueOf(byte val) {
        return this.valueOf((int)val);
    }

    public Integer valueOf(short val) {
        return this.valueOf((int)val);
    }

    public Integer valueOf(BigInteger val) {
        return new AbstractInteger.Big(val);
    }

    public Real valueOf(double val) {
        return new AbstractReal.Double(val);
    }

    public Real valueOf(float val) {
        return new AbstractReal.Double(val);
    }

    public Real valueOf(BigDecimal val) {
        return new AbstractReal.Big(val);
    }

    public Rational rational(Integer p, Integer q) {
        return new AbstractRational.RationalImpl((AbstractInteger)p, (AbstractInteger)q);
    }

    public Rational rational(int p, int q) {
        return new AbstractRational.RationalImpl(p, q);
    }

    public Rational rational(Integer p) {
        return new AbstractRational.RationalImpl((AbstractInteger)p);
    }

    public Rational rational(int p) {
        return new AbstractRational.RationalImpl(p);
    }

    public Complex complex(Real a, Real b) {
        return this.cartesian(a, b);
    }

    public Complex complex(double a, double b) {
        return this.cartesian(a, b);
    }

    public Complex complex(float a, float b) {
        return this.complex((double)a, (double)b);
    }

    public Complex complex(int a, int b) {
        return this.complex((double)a, (double)b);
    }

    public Complex complex(long a, long b) {
        return this.complex((double)a, (double)b);
    }

    public Complex complex(Real a) {
        return this.complex(a, Values.ZERO);
    }

    public Complex complex(double a) {
        return this.complex(a, 0.0);
    }

    public Complex cartesian(Real a, Real b) {
        return new AbstractComplex.ComplexImpl(a, b);
    }

    public Complex cartesian(double a, double b) {
        return new AbstractComplex.ComplexImpl(a, b);
    }

    public Complex polar(Real r, Real phi) {
        return new AbstractComplex.ComplexImpl(r.multiply((Real)Functions.cos.apply(phi)), r.multiply((Real)Functions.sin.apply(phi)));
    }

    public Complex polar(double r, double phi) {
        return new AbstractComplex.ComplexImpl(r * Math.cos(phi), r * Math.sin(phi));
    }

    public Vector valueOf(Arithmetic[] values) {
        return new ArithmeticVector(values);
    }

    public Vector valueOf(double[] values) {
        return new RVector(values);
    }

    public Vector valueOf(int[] values) {
        Vector v = this.newInstance(values.length);
        for (int i = 0; i < values.length; ++i) {
            v.set(i, (Arithmetic)this.valueOf(values[i]));
        }
        return v;
    }

    Vector vector(List values) {
        Vector r = this.newInstance(values.size());
        Iterator it = values.iterator();
        for (int i = 0; i < values.size(); ++i) {
            r.set(i, (Arithmetic)it.next());
        }
        if (!$assertionsDisabled && it.hasNext()) {
            throw new AssertionError((Object)"iterator should be finished after all elements");
        }
        return r;
    }

    public Vector newInstance(int dim) {
        return new ArithmeticVector(dim);
    }

    public Vector BASE(int n, int i) {
        ArithmeticVector base = (ArithmeticVector)this.newInstance(n);
        for (int j = 0; j < base.dimension(); ++j) {
            base.D[j] = j == i ? ONE : ZERO;
        }
        return base;
    }

    public Vector CONST(int n, Arithmetic c) {
        ArithmeticVector constant = (ArithmeticVector)this.newInstance(n);
        Arrays.fill(constant.D, c);
        return constant;
    }

    public Matrix valueOf(Arithmetic[][] values) {
        return new ArithmeticMatrix(values);
    }

    public Matrix valueOf(double[][] values) {
        return new RMatrix(values);
    }

    public Matrix valueOf(int[][] values) {
        for (int i = 1; i < values.length; ++i) {
            Utility.pre(values[i].length == values[i - 1].length, "rectangular array required");
        }
        Matrix v = this.newInstance(values.length, values[0].length);
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[0].length; ++j) {
                v.set(i, j, this.valueOf(values[i][j]));
            }
        }
        return v;
    }

    static Matrix matrix(List values) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Matrix newInstance(Dimension dimension) {
        return new ArithmeticMatrix(dimension);
    }

    public Matrix newInstance(int height, int width) {
        return new ArithmeticMatrix(height, width);
    }

    public Matrix IDENTITY(int height, int width) {
        if (width != height) {
            throw new IllegalArgumentException("identity matrix is square");
        }
        ArithmeticMatrix identity = (ArithmeticMatrix)this.newInstance(height, width);
        for (int i = 0; i < identity.dimension().height; ++i) {
            for (int j = 0; j < identity.dimension().width; ++j) {
                identity.D[i][j] = this.valueOf(Functions.delta(i, j));
            }
        }
        return identity;
    }

    public Vector tensor(Arithmetic[] values) {
        return this.valueOf(values);
    }

    public Matrix tensor(Arithmetic[][] values) {
        return this.valueOf(values);
    }

    public Tensor tensor(Arithmetic[][][] values) {
        return new ArithmeticTensor((Object[])values);
    }

    public Tensor tensor(Object values) {
        ArithmeticTensor t = new ArithmeticTensor((Object)values);
        switch (t.rank()) {
            case 0: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 1: {
                return this.validate(this.tensor((Arithmetic[])(values instanceof Arithmetic[] ? values : t.toArray__Tensor())), t.dimensions());
            }
            case 2: {
                return this.validate(this.tensor((Arithmetic[][])(values instanceof Arithmetic[][] ? values : t.toArray__Tensor())), t.dimensions());
            }
        }
        return this.validate(t, t.dimensions());
    }

    public Tensor newInstance(int[] dimensions) {
        switch (dimensions.length) {
            case 0: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 1: {
                return this.validate(this.newInstance(dimensions[0]), dimensions);
            }
            case 2: {
                return this.validate(this.newInstance(dimensions[0], dimensions[1]), dimensions);
            }
        }
        return this.validate(new ArithmeticTensor(dimensions), dimensions);
    }

    private final Tensor validate(Tensor t, int[] dimensions) {
        if (!$assertionsDisabled && t.rank() != dimensions.length) {
            throw new AssertionError((Object)"correct rank");
        }
        if (!$assertionsDisabled && !Utility.equalsAll(t.dimensions(), dimensions)) {
            throw new AssertionError((Object)"correct dimensions");
        }
        if (!$assertionsDisabled && t.rank() == 1 && !(t instanceof Vector)) {
            throw new AssertionError((Object)"rank 1 is vector");
        }
        if (!$assertionsDisabled && t.rank() == 2 && !(t instanceof Matrix)) {
            throw new AssertionError((Object)"rank 2 is matrix");
        }
        return t;
    }

    public Tensor ZERO(int[] dimensions) {
        Tensor zero = this.newInstance(dimensions);
        ListIterator i = zero.iterator();
        while (i.hasNext()) {
            i.next();
            i.set(Values.ZERO);
        }
        return zero;
    }

    public Polynomial polynomial(Object coefficients) {
        return this.asPolynomial(this.tensor(coefficients));
    }

    public Polynomial asPolynomial(Tensor coefficients) {
        switch (coefficients.rank()) {
            case 1: {
                return this.polynomial((Arithmetic[])((AbstractTensor)coefficients).toArray__Tensor());
            }
        }
        return new ArithmeticMultivariatePolynomial(coefficients);
    }

    public Tensor asTensor(Polynomial p) {
        return ((AbstractMultivariatePolynomial)p).tensorViewOfCoefficients();
    }

    public Polynomial constant(Polynomial p) {
        return p;
    }

    public final Polynomial MONOMIAL(Arithmetic coefficient, int[] exponents) {
        int[] dim = new int[exponents.length];
        for (int k = 0; k < dim.length; ++k) {
            dim[k] = exponents[k] + 1;
        }
        ArithmeticMultivariatePolynomial m = new ArithmeticMultivariatePolynomial(dim);
        ((AbstractMultivariatePolynomial)m).set(m.CONSTANT_TERM, coefficient.zero());
        m.setAllZero(m);
        ((AbstractMultivariatePolynomial)m).set(exponents, coefficient);
        return m;
    }

    public UnivariatePolynomial polynomial(Arithmetic[] coefficients) {
        return new ArithmeticUnivariatePolynomial(coefficients);
    }

    public UnivariatePolynomial asPolynomial(Vector a) {
        return this.polynomial(a.toArray());
    }

    public UnivariatePolynomial constant(UnivariatePolynomial p) {
        return p;
    }

    public Quotient quotient(Arithmetic a, Function mod) {
        return new AbstractQuotient(a, mod);
    }

    public Quotient quotient(Euclidean a, Euclidean m) {
        return new AbstractQuotient(a, m);
    }

    public Quotient quotient(Polynomial a, Set m, Comparator monomialOrder) {
        if (!$assertionsDisabled && !((Object)m).equals(AlgebraicAlgorithms.groebnerBasis(m, monomialOrder))) {
            throw new AssertionError((Object)(m + " is a Groebner basis with respect to " + monomialOrder));
        }
        return this.quotient((Arithmetic)a, AlgebraicAlgorithms.reduce(m, monomialOrder));
    }

    public Fraction fraction(Arithmetic a, Arithmetic s) {
        return new AbstractFraction(a, s);
    }

    public Symbol symbol(String signifier) {
        return new AbstractSymbol(signifier);
    }

    public Arithmetic valueOf(String s) throws NumberFormatException {
        try {
            return ArithmeticFormat.getDefaultInstance().parse(s);
        }
        catch (ClassCastException x) {
            throw new NumberFormatException("found " + x.getMessage());
        }
        catch (ParseException x) {
            throw new NumberFormatException(x.toString());
        }
    }

    public final Scalar narrow(Scalar val) {
        if (val instanceof Integer) {
            return val;
        }
        if (Complex.hasType.apply(val)) {
            Complex c = (Complex)val;
            if (!c.im().equals(Values.ZERO)) {
                return val;
            }
            val = c.re();
        }
        if (Real.isa.apply(val)) {
            Real r = (Real)val;
            try {
                if (MathUtilities.isInteger(r.doubleValue())) {
                    return this.valueOf((long)r.doubleValue());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (Rational.isa.apply(val)) {
                return (Rational)val;
            }
            return val;
        }
        return val;
    }

    public Scalar[] minimumCoerced(Number a, Number b) {
        if (Complex.hasType.apply(a) || Complex.hasType.apply(b)) {
            return new Complex[]{Complex.hasType.apply(a) ? (Complex)((Object)a) : new AbstractComplex.ComplexImpl(a), Complex.hasType.apply(b) ? (Complex)((Object)b) : new AbstractComplex.ComplexImpl(b)};
        }
        if (Integer.hasType.apply(a)) {
            if (Integer.hasType.apply(b)) {
                return new Integer[]{new AbstractInteger.Long(a), new AbstractInteger.Long(b)};
            }
        } else if (!Rational.hasType.apply(a)) {
            return new Real[]{new AbstractReal.Double(a), new AbstractReal.Double(b)};
        }
        if (Rational.hasType.apply(b)) {
            return new Rational[]{Rational.hasType.apply(a) ? (Rational)((Object)a) : this.rational(a.intValue()), Rational.hasType.apply(b) ? (Rational)((Object)b) : this.rational(b.intValue())};
        }
        return new Real[]{new AbstractReal.Double(a), new AbstractReal.Double(b)};
    }

    private final Arithmetic[] minimumCoerced(Arithmetic[] a) {
        if (!$assertionsDisabled && a.length != 2) {
            throw new AssertionError((Object)"currently for binary operations, only");
        }
        if (a[0].getClass() == a[1].getClass()) {
            return a;
        }
        if (a[0] instanceof Number && a[1] instanceof Number) {
            return this.minimumCoerced((Number)((Object)a[0]), (Number)((Object)a[1]));
        }
        if (a[0] instanceof Tensor || a[1] instanceof Tensor) {
            return a;
        }
        if (a[0] instanceof MathFunctor || a[0] instanceof Symbol) {
            return a;
        }
        if (a[1] instanceof MathFunctor || a[1] instanceof Symbol) {
            return new Arithmetic[]{ValuesImpl.makeSymbolAware(a[0]), a[1]};
        }
        throw new AssertionError((Object)("the types of the arguments could not be coerced: " + (a == null ? "null" : a[0].getClass() + "") + " and " + (a[1] == null ? "null" : a[1].getClass() + "")));
    }

    private static final Arithmetic makeSymbolAware(Arithmetic x) {
        if (!$assertionsDisabled && (x instanceof MathFunctor || x instanceof Symbol)) {
            throw new AssertionError((Object)"math functors and symbols are already aware of symbols");
        }
        return Functions.constant(x);
    }

    static {
        $assertionsDisabled = !ValuesImpl.class.desiredAssertionStatus();
        symbolic = new Predicate(){

            public boolean apply(Object expression) {
                if (expression instanceof Functor.Composite) {
                    Functor.Composite c = (Functor.Composite)expression;
                    Object compositor = c.getCompositor();
                    Collection components = Utility.asCollection(c.getComponent());
                    if (components == null) {
                        throw new NullPointerException(c + " of " + c.getClass() + " has compositor " + compositor + " and components " + components);
                    }
                    return this.apply(compositor) || Setops.some(components, (Predicate)this);
                }
                if (expression instanceof VoidFunction) {
                    return this.apply(((VoidFunction)expression).apply());
                }
                return Utility.isIteratable(expression) ? Setops.some(Utility.asIterator(expression), (Predicate)this) : Symbol.isa.apply(expression);
            }
        };
        posConst = new Integer[11];
        negConst = new Integer[11];
        ValuesImpl.posConst[0] = ValuesImpl.negConst[0] = new AbstractInteger.Long(0L);
        for (int i = 1; i <= 10; ++i) {
            ValuesImpl.posConst[i] = new AbstractInteger.Long(i);
            ValuesImpl.negConst[i] = new AbstractInteger.Long(-i);
        }
    }
}

