/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.awt.Point;
import java.util.Arrays;
import orbital.math.Arithmetic;
import orbital.math.Real;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.moon.math.AbstractVector;
import orbital.moon.math.ArithmeticVector;
import orbital.util.Utility;

class RVector
extends AbstractVector
implements Cloneable {
    private static final long serialVersionUID = -4024410371344073971L;
    protected double[] D;

    public static final Vector ZERO(int length) {
        return RVector.CONST(length, 0.0);
    }

    public static final Vector BASE(int length, int e_i) {
        RVector base = new RVector(length);
        Arrays.fill(base.D, 0.0);
        base.D[e_i] = 1.0;
        return base;
    }

    public static final Vector CONST(int length, double c) {
        RVector constant = new RVector(length);
        Arrays.fill(constant.D, c);
        return constant;
    }

    public RVector(int length) {
        this.D = new double[length];
    }

    public RVector() {
        this(0);
    }

    public RVector(double[] values) {
        this.D = values;
    }

    public RVector(Real[] values) {
        this.D = new double[values.length];
        for (int i = 0; i < this.D.length; ++i) {
            this.D[i] = values[i].doubleValue();
        }
    }

    public RVector(Point p) {
        this(2);
        this.D[0] = p.x;
        this.D[1] = p.y;
    }

    protected Vector newInstance(int dim) {
        return new RVector(dim);
    }

    public final int dimension() {
        return this.D.length;
    }

    public Arithmetic get(int i) {
        this.validate(i);
        return Values.getDefaultInstance().valueOf(this.D[i]);
    }

    public double getDoubleValue(int i) {
        this.validate(i);
        return this.D[i];
    }

    public void set(int i, double vi) {
        this.validate(i);
        this.D[i] = vi;
    }

    public void set(int i, Arithmetic vi) {
        this.set(i, ((Real)vi).doubleValue());
    }

    protected void set(Arithmetic[] v) {
        ++this.modCount;
        this.D = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.set(i, v[i]);
        }
    }

    public Vector add(Vector b) {
        if (!(b instanceof RVector)) {
            return new ArithmeticVector(this.toArray()).add(b);
        }
        Utility.pre(this.dimension() == b.dimension(), "Vector A+B only defined for same size");
        RVector bb = (RVector)b;
        RVector ret = new RVector(this.dimension());
        for (int i = 0; i < this.dimension(); ++i) {
            ret.D[i] = this.D[i] + bb.D[i];
        }
        return ret;
    }

    public Vector subtract(Vector b) {
        if (!(b instanceof RVector)) {
            return new ArithmeticVector(this.toArray()).subtract(b);
        }
        Utility.pre(this.dimension() == b.dimension(), "Vector A-B only defined for same size");
        RVector bb = (RVector)b;
        RVector ret = new RVector(this.dimension());
        for (int i = 0; i < this.dimension(); ++i) {
            ret.D[i] = this.D[i] - bb.D[i];
        }
        return ret;
    }

    public Vector scale(double s) {
        RVector ret = new RVector(this.dimension());
        for (int i = 0; i < this.dimension(); ++i) {
            ret.D[i] = this.D[i] * s;
        }
        return ret;
    }

    public Arithmetic scale(Arithmetic b) {
        if (!Real.isa.apply(b)) {
            return new ArithmeticVector(this.toArray()).scale(b);
        }
        return this.scale(((Real)b).doubleValue());
    }

    public Arithmetic multiply(Vector b) {
        if (!(b instanceof RVector)) {
            return new ArithmeticVector(this.toArray()).multiply(b);
        }
        Utility.pre(this.dimension() == b.dimension(), "vectors for dot-product must have equal dimension");
        RVector bb = (RVector)b;
        double ret = 0.0;
        for (int i = 0; i < this.dimension(); ++i) {
            ret += this.D[i] * bb.D[i];
        }
        return Values.getDefaultInstance().valueOf(ret);
    }

    public Vector cross(Vector b) {
        if (!(b instanceof RVector)) {
            return new ArithmeticVector(this.toArray()).cross(b);
        }
        Utility.pre(this.dimension() == 3 && this.dimension() == b.dimension(), "domain of cross-product is 3D");
        RVector bb = (RVector)b;
        return new RVector(new double[]{this.getDoubleValue(1) * bb.getDoubleValue(2) - this.getDoubleValue(2) * bb.getDoubleValue(1), this.getDoubleValue(2) * bb.getDoubleValue(0) - this.getDoubleValue(0) * bb.getDoubleValue(2), this.getDoubleValue(0) * bb.getDoubleValue(1) - this.getDoubleValue(1) * bb.getDoubleValue(0)});
    }

    public double[] toDoubleArray() {
        return (double[])this.D.clone();
    }
}

