/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.io.Serializable;
import orbital.math.Arithmetic;
import orbital.math.ArithmeticFormat;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Symbol;
import orbital.math.Values;
import orbital.math.functional.Functionals;
import orbital.math.functional.Operations;
import orbital.util.Utility;

class AbstractSymbol
implements Symbol,
Serializable {
    private static final long serialVersionUID = -3807941418810639427L;
    private String signifier;

    public AbstractSymbol(String signifier) {
        this.signifier = signifier;
    }

    public String getSignifier() {
        return this.signifier;
    }

    public boolean isVariable() {
        return true;
    }

    public boolean equals(Object o) {
        if (!isa.apply(o)) {
            return false;
        }
        return Utility.equals(this.getSignifier(), ((Symbol)o).getSignifier());
    }

    public boolean equals(Object o, Real tolerance) {
        return tolerance.isInfinite() && tolerance.compareTo(Values.ZERO) > 0 ? true : this.equals(o);
    }

    public int hashCode() {
        return Utility.hashCode(this.signifier);
    }

    public Arithmetic zero() {
        return Values.ZERO;
    }

    public Arithmetic one() {
        return Values.ONE;
    }

    public Arithmetic add(Arithmetic b) throws ArithmeticException {
        if (b instanceof Scalar && Values.ZERO.equals(b)) {
            return this;
        }
        return Functionals.genericCompose(Operations.plus, (Object)this, (Object)b);
    }

    public Arithmetic minus() throws ArithmeticException {
        return Functionals.genericCompose(Operations.minus, (Object)this);
    }

    public Arithmetic subtract(Arithmetic b) throws ArithmeticException {
        if (b instanceof Scalar && Values.ZERO.equals(b)) {
            return this;
        }
        return Functionals.genericCompose(Operations.subtract, (Object)this, (Object)b);
    }

    public Arithmetic scale(Arithmetic alpha) throws ArithmeticException {
        return this.multiply(alpha);
    }

    public Arithmetic multiply(Arithmetic b) throws ArithmeticException {
        if (b instanceof Scalar) {
            if (Values.ONE.equals(b)) {
                return this;
            }
            if (Values.MINUS_ONE.equals(b)) {
                return this.minus();
            }
            if (Values.ZERO.equals(b)) {
                return Values.ZERO;
            }
        }
        return Functionals.genericCompose(Operations.times, (Object)this, (Object)b);
    }

    public Arithmetic inverse() throws ArithmeticException {
        return Functionals.genericCompose(Operations.inverse, (Object)this);
    }

    public Arithmetic divide(Arithmetic b) throws ArithmeticException {
        if (b instanceof Scalar) {
            if (Values.ONE.equals(b)) {
                return this;
            }
            if (Values.MINUS_ONE.equals(b)) {
                return this.minus();
            }
            if (Values.ZERO.equals(b)) {
                throw new ArithmeticException("division by zero");
            }
        }
        return Functionals.genericCompose(Operations.divide, (Object)this, (Object)b);
    }

    public Arithmetic power(Arithmetic b) throws ArithmeticException {
        if (b instanceof Scalar) {
            if (Values.ONE.equals(b)) {
                return this;
            }
            if (Values.MINUS_ONE.equals(b)) {
                return this.inverse();
            }
            if (Values.ZERO.equals(b)) {
                return Values.ONE;
            }
        }
        return Functionals.genericCompose(Operations.power, (Object)this, (Object)b);
    }

    public Real norm() {
        return Values.NaN;
    }

    public String toString() {
        return ArithmeticFormat.getDefaultInstance().format(this);
    }
}

