/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import orbital.algorithm.Combinatorical;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.Predicates;
import orbital.math.Arithmetic;
import orbital.math.Integer;
import orbital.math.Polynomial;
import orbital.math.Tensor;
import orbital.math.Values;
import orbital.math.functional.Functionals;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractPolynomial;
import orbital.moon.math.AbstractTensor;
import orbital.util.Setops;
import orbital.util.Utility;

abstract class AbstractMultivariatePolynomial
extends AbstractPolynomial {
    private static final long serialVersionUID = -2237060189065872837L;
    transient int[] CONSTANT_TERM;
    protected transient int modCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractMultivariatePolynomial() {
    }

    public boolean equals(Object o) {
        if (o instanceof Polynomial) {
            AbstractMultivariatePolynomial b = (AbstractMultivariatePolynomial)o;
            int[] d = Functionals.map((BinaryFunction)Operations.max, this.dimensions(), b.dimensions());
            return Setops.all(this.iterator(d), b.iterator(d), Predicates.equal);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected Object productIndexSet(Arithmetic productObject) {
        return this.dimensions();
    }

    protected abstract int[] dimensions();

    abstract Tensor tensorViewOfCoefficients();

    protected abstract Arithmetic get(int[] var1);

    protected abstract void set(int[] var1, Arithmetic var2);

    protected abstract Polynomial newInstance(int[] var1);

    protected final Arithmetic newInstance(Object productIndexSet) {
        return this.newInstance((int[])productIndexSet);
    }

    public final ListIterator iterator() {
        return this.iterator(this.dimensions());
    }

    public Iterator indices() {
        return new ListIterator(){
            private final Combinatorical cursor;
            private transient int expectedModCount;
            {
                this.cursor = Combinatorical.getPermutations(AbstractMultivariatePolynomial.this.dimensions());
                this.expectedModCount = AbstractMultivariatePolynomial.this.modCount;
            }

            public boolean hasNext() {
                return this.cursor.hasNext();
            }

            public Object next() {
                try {
                    Tensor v = Values.getDefaultInstance().tensor(this.cursor.next());
                    this.checkForComodification();
                    return v;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"cursor should already have thrown a NoSuchElementException"))).initCause(e));
                }
            }

            public boolean hasPrevious() {
                return this.cursor.hasPrevious();
            }

            public Object previous() {
                try {
                    Tensor v = Values.getDefaultInstance().tensor(this.cursor.previous());
                    this.checkForComodification();
                    return v;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"cursor should already have thrown a NoSuchElementException"))).initCause(e));
                }
            }

            public void set(Object o) {
                throw new UnsupportedOperationException("setting elements in an index set of a polynomial is undefined");
            }

            public int nextIndex() {
                throw new UnsupportedOperationException("a polynomial does not have a one-dimensional index");
            }

            public int previousIndex() {
                throw new UnsupportedOperationException("a polynomial does not have a one-dimensional index");
            }

            public void add(Object o) {
                throw new UnsupportedOperationException("adding elements to an index set of a polynomial is undefined");
            }

            public void remove() {
                throw new UnsupportedOperationException("removing elements from an index set of a polynomial is undefined");
            }

            private final void checkForComodification() {
                if (AbstractMultivariatePolynomial.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    ListIterator iterator(final int[] dim) {
        for (int k = 0; k < dim.length; ++k) {
            Utility.pre(dim[k] >= this.dimensions()[k], "forall k dim[k]>=dimensions()[k]");
        }
        return new ListIterator(){
            private final Combinatorical cursor;
            private int[] lastRet;
            private transient int expectedModCount;
            {
                this.cursor = Combinatorical.getPermutations(dim);
                this.lastRet = null;
                this.expectedModCount = AbstractMultivariatePolynomial.this.modCount;
            }

            public boolean hasNext() {
                return this.cursor.hasNext();
            }

            public Object next() {
                try {
                    this.lastRet = (int[])this.cursor.next().clone();
                    Arithmetic v = AbstractMultivariatePolynomial.this.get(this.lastRet);
                    this.checkForComodification();
                    return v;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"cursor should already have thrown a NoSuchElementException"))).initCause(e));
                }
            }

            public boolean hasPrevious() {
                return this.cursor.hasPrevious();
            }

            public Object previous() {
                try {
                    this.lastRet = (int[])this.cursor.previous().clone();
                    Arithmetic v = AbstractMultivariatePolynomial.this.get(this.lastRet);
                    this.checkForComodification();
                    return v;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"cursor should already have thrown a NoSuchElementException"))).initCause(e));
                }
            }

            public void set(Object o) {
                if (!(o instanceof Arithmetic)) {
                    throw new IllegalArgumentException();
                }
                if (this.lastRet == null) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    AbstractMultivariatePolynomial.this.set(this.lastRet, (Arithmetic)o);
                    this.expectedModCount = AbstractMultivariatePolynomial.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            public int nextIndex() {
                throw new UnsupportedOperationException("a polynomial does not have a one-dimensional index");
            }

            public int previousIndex() {
                throw new UnsupportedOperationException("a polynomial does not have a one-dimensional index");
            }

            public void add(Object o) {
                throw new UnsupportedOperationException("adding a single element from a polynomial is impossible");
            }

            public void remove() {
                throw new UnsupportedOperationException("removing a single element from a polynomial is impossible");
            }

            private final void checkForComodification() {
                if (AbstractMultivariatePolynomial.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public Arithmetic zero() {
        int[] dim = new int[((Integer)this.indexSet()).intValue()];
        Arrays.fill(dim, 1);
        AbstractMultivariatePolynomial r = (AbstractMultivariatePolynomial)this.newInstance(dim);
        r.set(this.CONSTANT_TERM, this.get(this.CONSTANT_TERM).zero());
        return r;
    }

    public Arithmetic one() {
        int[] dim = new int[((Integer)this.indexSet()).intValue()];
        Arrays.fill(dim, 1);
        AbstractMultivariatePolynomial r = (AbstractMultivariatePolynomial)this.newInstance(dim);
        r.set(this.CONSTANT_TERM, this.get(this.CONSTANT_TERM).one());
        return r;
    }

    protected Arithmetic operatorImpl(BinaryFunction op, Arithmetic bb) {
        AbstractMultivariatePolynomial b = (AbstractMultivariatePolynomial)bb;
        if (!this.indexSet().equals(b.indexSet())) {
            throw new IllegalArgumentException("a+b only defined for equal indexSet()");
        }
        int[] d = Functionals.map((BinaryFunction)Operations.max, this.dimensions(), b.dimensions());
        AbstractMultivariatePolynomial ret = (AbstractMultivariatePolynomial)this.newInstance(d);
        ListIterator dst = ret.iterator(d);
        Setops.copy(dst, Functionals.map(op, this.iterator(d), b.iterator(d)));
        if (!$assertionsDisabled && dst.hasNext()) {
            throw new AssertionError((Object)"equal dimensions for iterator view implies equal structure of iterators");
        }
        return ret;
    }

    public Polynomial multiply(Polynomial bb) {
        AbstractMultivariatePolynomial b = (AbstractMultivariatePolynomial)bb;
        if (this.degreeValue() < 0) {
            return this;
        }
        if (b.degreeValue() < 0) {
            return b;
        }
        int[] d = Functionals.map((BinaryFunction)Operations.plus, this.dimensions(), b.dimensions());
        Polynomial ret = this.newInstance(d);
        this.setAllZero(ret);
        Combinatorical index = Combinatorical.getPermutations(this.dimensions());
        while (index.hasNext()) {
            int[] i = index.next();
            AbstractMultivariatePolynomial si = (AbstractMultivariatePolynomial)this.newInstance(Functionals.map((BinaryFunction)Operations.plus, i, b.dimensions()));
            this.setAllZero(si);
            int[] sidim = si.dimensions();
            int[] sidim_1 = new int[sidim.length];
            for (int k = 0; k < sidim_1.length; ++k) {
                sidim_1[k] = sidim[k] - 1;
            }
            ((AbstractTensor)si.tensorViewOfCoefficients()).setSubTensor(i, sidim_1, ((AbstractMultivariatePolynomial)b.scale(this.get(i))).tensorViewOfCoefficients());
            ret = ret.add(si);
        }
        return ret;
    }

    static {
        $assertionsDisabled = !AbstractMultivariatePolynomial.class.desiredAssertionStatus();
    }
}

