/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.awt;

import java.applet.Applet;
import java.awt.Event;
import java.awt.Frame;
import orbital.awt.UIUtilities;
import orbital.moon.awt.StandaloneAppletStub;
import orbital.signe;

public class AppletFrame
extends Frame {
    public static final String usage = "usage: " + AppletFrame.class + " <className> [<Title> (<parameter>=<value>)* | " + signe.getHelpRequest() + "]" + System.getProperty("line.separator") + "\twill display the applet <className> in a new frame called <Title>." + System.getProperty("line.separator") + "\tThe applet has access to the values assigned to the parameters." + System.getProperty("line.separator") + "\t" + signe.getHelpRequest() + "\tdisplay available parameter info for applet <className>";

    public static void main(String[] args) throws Exception {
        if (args.length < 1 || signe.isHelpRequest(args[0])) {
            System.out.println(usage);
            return;
        }
        if (args.length == 2 && signe.isHelpRequest(args[1])) {
            System.out.println(usage);
        }
        UIUtilities.setDefaultLookAndFeel();
        String className = args[0];
        String title = args.length > 1 ? args[1] : "Application Title";
        System.out.println("starting Applet " + className + " '" + title + "'");
        int consumedArguments = args.length > 1 ? 2 : 1;
        String[] remainingArgs = new String[args.length - consumedArguments];
        System.arraycopy(args, consumedArguments, remainingArgs, 0, remainingArgs.length);
        AppletFrame.showApplet(className, title, remainingArgs);
    }

    public static String info(Applet a) {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("applet ");
        sb.append(a.getClass().getName());
        sb.append(nl);
        sb.append("supports the following parameters:");
        sb.append(nl);
        String[][] params = a.getParameterInfo();
        for (int i = 0; i < params.length; ++i) {
            for (int j = 0; j < params[i].length; ++j) {
                sb.append((j > 0 ? " -- " : "") + params[i][j]);
            }
            sb.append(nl);
        }
        return sb.toString();
    }

    public static void showApplet(String appletClassName, String title) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        AppletFrame.showApplet(appletClassName, title, null);
    }

    public static void showApplet(String appletClassName, String title, String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Applet a = (Applet)Class.forName(appletClassName).newInstance();
        AppletFrame.showApplet(a, title, args);
    }

    public static void showApplet(Applet a, String title) {
        AppletFrame.showApplet(a, title, new String[0]);
    }

    public static void showApplet(Applet a, String title, String[] args) {
        if (args.length == 1 && signe.isHelpRequest(args[0])) {
            System.out.println(AppletFrame.info(a));
        }
        AppletFrame frame = new AppletFrame(title);
        a.setStub(new StandaloneAppletStub(a, frame, args));
        frame.add("Center", a);
        a.init();
        a.start();
        frame.pack();
        frame.show();
    }

    public AppletFrame(String name) {
        super(name);
    }

    public boolean handleEvent(Event e) {
        if (e.id == 201) {
            System.exit(0);
            return true;
        }
        return super.handleEvent(e);
    }
}

