/*
 * Decompiled with CFR 0.152.
 */
package orbital.math.functional;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import orbital.logic.functor.Functor;
import orbital.logic.sign.concrete.Notation;
import orbital.math.Arithmetic;
import orbital.math.Matrix;
import orbital.math.Scalar;
import orbital.math.Tensor;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.AbstractBinaryFunction;
import orbital.math.functional.AbstractFunction;
import orbital.math.functional.BinaryFunction;
import orbital.math.functional.ComponentCompositions;
import orbital.math.functional.Compositions;
import orbital.math.functional.Function;
import orbital.math.functional.Functions;
import orbital.math.functional.MathFunctor;
import orbital.math.functional.MathFunctor_CompositeFunctor;
import orbital.math.functional.Operations;
import orbital.util.GeneralComplexionException;
import orbital.util.Utility;

public class Functionals
extends orbital.logic.functor.Functionals {
    private static final Logger logger = Logger.getLogger(Functionals.class.getPackage().getName());
    public static final Functionals functionals = new Functionals();
    static /* synthetic */ Class class$orbital$math$functional$Function;

    protected Functionals() {
    }

    public static Function compose(Function f, Function g) {
        if (f instanceof Functions.ConstantFunction) {
            return f;
        }
        return new Compositions.CompositeFunction(f, g);
    }

    public static BinaryFunction compose(BinaryFunction f, BinaryFunction g, BinaryFunction h) {
        if (f instanceof Functions.BinaryConstantFunction) {
            return f;
        }
        return new Compositions.CompositeBinaryFunction(f, g, h);
    }

    public static Function compose(BinaryFunction f, Function g, Function h) {
        if (f instanceof Functions.BinaryConstantFunction) {
            return Functions.constant(((Functions.BinaryConstantFunction)f).a);
        }
        return new BinaryCompositeFunction(f, g, h);
    }

    public static MathFunctor genericCompose(Function f, Object g) {
        if (g instanceof MathFunctor) {
            if (g instanceof Function) {
                return Functionals.compose(f, (Function)g);
            }
            if (g instanceof Function[] || g instanceof Function[][]) {
                return Functionals.genericCompose(f, (Object)Functionals.genericCompose(g));
            }
        } else if (g instanceof Arithmetic && !(g instanceof Functor)) {
            return Functionals.compose(f, Functions.constant((Arithmetic)g));
        }
        throw new IllegalArgumentException("illegal type to compose " + (g == null ? "null" : g.getClass() + ""));
    }

    public static MathFunctor.Composite genericCompose(Object f) {
        if (f instanceof Function[]) {
            return new ComponentCompositions.ComponentCompositeFunction((Function[])f);
        }
        if (f instanceof Function[][]) {
            return new ComponentCompositions.MatrixComponentCompositeFunction((Function[][])f);
        }
        if (f instanceof BinaryFunction[][]) {
            return new ComponentCompositions.MatrixComponentCompositeBinaryFunction((BinaryFunction[][])f);
        }
        throw new IllegalArgumentException("illegal type to compose " + (f == null ? "null" : f.getClass() + ""));
    }

    public static MathFunctor genericCompose(BinaryFunction f, Object g, Object h) {
        if (g instanceof MathFunctor || h instanceof MathFunctor) {
            if (g instanceof Function && h instanceof Function) {
                return Functionals.compose(f, (Function)g, (Function)h);
            }
            if (g instanceof BinaryFunction && h instanceof BinaryFunction) {
                return Functionals.compose(f, (BinaryFunction)g, (BinaryFunction)h);
            }
            if (g instanceof Function && !(h instanceof MathFunctor) && h instanceof Arithmetic) {
                return Functionals.compose(f, (Function)g, Functions.constant((Arithmetic)h));
            }
            if (!(g instanceof MathFunctor) && g instanceof Arithmetic && h instanceof Function) {
                return Functionals.compose(f, Functions.constant((Arithmetic)g), (Function)h);
            }
            if (g instanceof BinaryFunction && !(h instanceof MathFunctor) && h instanceof Arithmetic) {
                return Functionals.compose(f, (BinaryFunction)g, Functions.binaryConstant((Arithmetic)h));
            }
            if (!(g instanceof MathFunctor) && g instanceof Arithmetic && h instanceof BinaryFunction) {
                return Functionals.compose(f, Functions.binaryConstant((Arithmetic)g), (BinaryFunction)h);
            }
        } else if (!(g instanceof Functor) && g instanceof Arithmetic && !(h instanceof Functor) && h instanceof Arithmetic) {
            return Functionals.compose(f, Functions.constant((Arithmetic)g), Functions.constant((Arithmetic)h));
        }
        throw new IllegalArgumentException("the type of the arguments to compose do not match: " + (g == null ? "null" : g.getClass() + "") + " and " + (h == null ? "null" : h.getClass() + ""));
    }

    public static Function bindFirst(final BinaryFunction f, final Object x) {
        return new AbstractFunction(){

            public Object apply(Object y) {
                return f.apply(x, y);
            }

            public Function derive() {
                logger.log(Level.FINE, "bindFirst.derive()", ((Object[][])((MathFunctor.Composite)((Object)f.derive())).getComponent())[0][1]);
                return Functionals.bindFirst(((BinaryFunction[][])((MathFunctor.Composite)((Object)f.derive())).getComponent())[0][1], x);
            }

            public Function integrate() {
                return Functionals.bindFirst(f.integrate(1), x);
            }

            public String toString() {
                return Notation.DEFAULT.format(f, new Object[]{x, "#0"});
            }
        };
    }

    public static Function bindSecond(final BinaryFunction f, final Object y) {
        return new AbstractFunction(){

            public Object apply(Object x) {
                return f.apply(x, y);
            }

            public Function derive() {
                logger.log(Level.FINE, "bindFirst.derive()", ((BinaryFunction[][])((MathFunctor.Composite)((Object)f.derive())).getComponent())[0][0]);
                return Functionals.bindSecond(((BinaryFunction[][])((MathFunctor.Composite)((Object)f.derive())).getComponent())[0][0], y);
            }

            public Function integrate() {
                return Functionals.bindSecond(f.integrate(0), y);
            }

            public String toString() {
                return Notation.DEFAULT.format(f, new Object[]{"#0", y});
            }
        };
    }

    public static Function bind(final BinaryFunction f) {
        return new AbstractFunction(){

            public Object apply(Object x) {
                return f.apply(x, x);
            }

            public Function derive() {
                throw new UnsupportedOperationException("TODO: check & verify");
            }

            public Function integrate() {
                throw new UnsupportedOperationException("dunno");
            }

            public String toString() {
                return Notation.DEFAULT.format(f, new String[]{"#0", "#0"});
            }
        };
    }

    public static BinaryFunction onFirst(final Function f) {
        return new AbstractBinaryFunction(){

            public Object apply(Object first, Object second) {
                return f.apply(first);
            }

            public BinaryFunction derive() {
                return (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{Functionals.onFirst(f.derive()), Functions.binaryzero}}));
            }

            public BinaryFunction integrate(int i) {
                Utility.pre(0 <= i && i <= 1, "binary integral");
                return i == 0 ? Functionals.onFirst(f.integrate()) : Functions.binaryzero;
            }

            public String toString() {
                return Notation.DEFAULT.format(f, new String[]{"#0"});
            }
        };
    }

    public static BinaryFunction onSecond(final Function f) {
        return new AbstractBinaryFunction(){

            public Object apply(Object first, Object second) {
                return f.apply(second);
            }

            public BinaryFunction derive() {
                return (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{Functions.binaryzero, Functionals.onSecond(f.derive())}}));
            }

            public BinaryFunction integrate(int i) {
                Utility.pre(0 <= i && i <= 1, "binary integral");
                return i == 0 ? Functions.binaryzero : Functionals.onSecond(f.integrate());
            }

            public String toString() {
                return Notation.DEFAULT.format(f, new String[]{"#1"});
            }
        };
    }

    static BinaryFunction on(int i, Function f) {
        Utility.pre(0 == i || i == 1, "binary function");
        return i == 0 ? Functionals.onFirst(f) : Functionals.onSecond(f);
    }

    public static BinaryFunction swap(final BinaryFunction f) {
        return new AbstractBinaryFunction(){

            public Object apply(Object x, Object y) {
                return f.apply(y, x);
            }

            public BinaryFunction derive() {
                BinaryFunction[] fd = ((BinaryFunction[][])((MathFunctor.Composite)((Object)f.derive())).getComponent())[0];
                return (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{Functionals.swap(fd[1]), Functionals.swap(fd[0])}}));
            }

            public BinaryFunction integrate(int i) {
                Utility.pre(0 <= i && i <= 1, "binary integral");
                return i == 0 ? f.integrate(1) : f.integrate(0);
            }

            public String toString() {
                return Notation.DEFAULT.format(f, new String[]{"#1", "#0"});
            }
        };
    }

    public static Tensor map(Function f, Tensor a) {
        return (Tensor)Functionals.map((orbital.logic.functor.Function)f, a);
    }

    public static Vector map(Function f, Vector a) {
        return (Vector)Functionals.map(f, (Tensor)a);
    }

    public static Matrix map(Function f, Matrix a) {
        return (Matrix)Functionals.map(f, (Tensor)a);
    }

    public static Tensor map(BinaryFunction f, Tensor x, Tensor y) {
        Utility.pre(Utility.equalsAll(x.dimensions(), y.dimensions()), "compatible dimensions");
        Tensor r = Values.getDefaultInstance().newInstance(x.dimensions());
        Functionals.mapInto((orbital.logic.functor.BinaryFunction)f, (Iterator)x.iterator(), (Iterator)y.iterator(), r.iterator());
        return r;
    }

    public static Vector map(BinaryFunction f, Vector x, Vector y) {
        return (Vector)Functionals.map(f, (Tensor)x, (Tensor)y);
    }

    public static Matrix map(BinaryFunction f, Matrix x, Matrix y) {
        return (Matrix)Functionals.map(f, (Tensor)x, (Tensor)y);
    }

    public static double foldRight(orbital.logic.functor.BinaryFunction f, double c, double[] a) {
        Values vf = Values.getDefaultInstance();
        Object result = vf.valueOf(c);
        for (int i = a.length - 1; i >= 0; --i) {
            result = f.apply(vf.valueOf(a[i]), result);
        }
        return ((Number)result).doubleValue();
    }

    public static double[] map(orbital.logic.functor.Function f, double[] a) {
        Values vf = Values.getDefaultInstance();
        double[] r = new double[a.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = ((Number)f.apply(vf.valueOf(a[i]))).doubleValue();
        }
        return r;
    }

    public static int[] map(orbital.logic.functor.Function f, int[] a) {
        return (int[])Functionals.mapImpl(f, a);
    }

    public static long[] map(orbital.logic.functor.Function f, long[] a) {
        return (long[])Functionals.mapImpl(f, a);
    }

    public static float[] map(orbital.logic.functor.Function f, float[] a) {
        return (float[])Functionals.mapImpl(f, a);
    }

    private static Object mapImpl(orbital.logic.functor.Function f, Object a) {
        Utility.pre(a != null && a.getClass().isArray(), "map(Function, Object) works on arrays of primitive types or their compound wrapper classes, only");
        Values vf = Values.getDefaultInstance();
        Object r = Array.newInstance(a.getClass().getComponentType(), Array.getLength(a));
        for (int i = 0; i < Array.getLength(r); ++i) {
            Object o = f.apply(vf.valueOf((Number)Array.get(a, i)));
            Array.set(r, i, Values.isPrimitiveWrapper(o.getClass()) ? o : Values.toPrimitiveWrapper((Scalar)o));
        }
        return r;
    }

    public static double[] map(orbital.logic.functor.BinaryFunction f, double[] x, double[] y) {
        Utility.pre(x.length == y.length, "argument arrays must have same length");
        Values vf = Values.getDefaultInstance();
        double[] a = new double[x.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = ((Number)f.apply(vf.valueOf(x[i]), vf.valueOf(y[i]))).doubleValue();
        }
        return a;
    }

    public static int[] map(orbital.logic.functor.BinaryFunction f, int[] x, int[] y) {
        return (int[])Functionals.mapImpl(f, x, y);
    }

    public static long[] map(orbital.logic.functor.BinaryFunction f, long[] x, long[] y) {
        return (long[])Functionals.mapImpl(f, x, y);
    }

    public static float[] map(orbital.logic.functor.BinaryFunction f, float[] x, float[] y) {
        return (float[])Functionals.mapImpl(f, x, y);
    }

    private static Object mapImpl(orbital.logic.functor.BinaryFunction f, Object x, Object y) {
        Utility.pre(x != null && x.getClass().isArray() && y != null && y.getClass().isArray(), "map(BinaryFunction, Object, Object) works on arrays of primitive types or their compound wrapper classes, only");
        Utility.pre(Array.getLength(x) == Array.getLength(y), "argument arrays must have same length");
        Values vf = Values.getDefaultInstance();
        Object r = Array.newInstance(x.getClass().getComponentType(), Array.getLength(x));
        for (int i = 0; i < Array.getLength(r); ++i) {
            Object o = f.apply(vf.valueOf((Number)Array.get(x, i)), vf.valueOf((Number)Array.get(y, i)));
            Array.set(r, i, Values.isPrimitiveWrapper(o.getClass()) ? o : Values.toPrimitiveWrapper((Scalar)o));
        }
        return r;
    }

    public static Function nest(Function f, int n) {
        Utility.pre(n >= 0, "non negative nesting expected");
        if (n == 0) {
            return Functions.id;
        }
        Function r = f;
        for (int i = 1; i < n; ++i) {
            r = Functionals.compose(f, r);
        }
        return r;
    }

    public static Function pointwise(Function elemental) {
        return new Functions.PointwiseFunction(elemental);
    }

    public static BinaryFunction pointwise(BinaryFunction elemental) {
        return new Functions.PointwiseBinaryFunction(elemental);
    }

    private static class BinaryCompositeFunction
    extends MathFunctor_CompositeFunctor
    implements Function.Composite {
        protected BinaryFunction outer;
        protected Function left;
        protected Function right;

        public BinaryCompositeFunction(BinaryFunction f, Function g, Function h) {
            this(f, g, h, null);
        }

        public BinaryCompositeFunction(BinaryFunction f, Function g, Function h, Notation notation) {
            super(notation);
            this.outer = f;
            this.left = g;
            this.right = h;
        }

        private BinaryCompositeFunction() {
        }

        public Object getCompositor() {
            return this.outer;
        }

        public Object getComponent() {
            return new Function[]{this.left, this.right};
        }

        public void setCompositor(Object f) throws ClassCastException {
            this.outer = (BinaryFunction)f;
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            Function[] a = (Function[])g;
            if (a.length != 2) {
                throw new IllegalArgumentException((class$orbital$math$functional$Function == null ? (class$orbital$math$functional$Function = Functionals.class$("orbital.math.functional.Function")) : class$orbital$math$functional$Function) + "[2] expected");
            }
            this.left = a[0];
            this.right = a[1];
        }

        public Object apply(Object arg) {
            return this.outer.apply(this.left.apply(arg), this.right.apply(arg));
        }

        public Function derive() {
            BinaryFunction[] od = ((BinaryFunction[][])((MathFunctor.Composite)((Object)this.outer.derive())).getComponent())[0];
            return Functionals.compose(Operations.plus, Functionals.compose(Operations.times, this.left.derive(), Functionals.compose(od[0], this.left, this.right)), Functionals.compose(Operations.times, Functionals.compose(od[1], this.left, this.right), this.right.derive()));
        }

        public Function integrate() {
            if (this.outer == Operations.plus) {
                return Functionals.compose(Operations.plus, this.left.integrate(), this.right.integrate());
            }
            if (this.outer == Operations.subtract) {
                return Functionals.compose(Operations.subtract, this.left.integrate(), this.right.integrate());
            }
            if (this.outer == Operations.times) {
                // empty if block
            }
            throw new GeneralComplexionException("integrating a composition would require integral substitution");
        }
    }
}

