/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import java.util.Map;
import java.util.PropertyPermission;
import orbital.math.Complex;
import orbital.math.FactoryConfigurationError;
import orbital.math.GetPropertyAction;
import orbital.math.Integer;
import orbital.math.Rational;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.ValueFactory;
import orbital.moon.math.AbstractValues;
import orbital.moon.math.ValuesImpl;

public abstract class Values
implements ValueFactory {
    private static Values defaultValueFactory;
    public static final Integer ZERO;
    public static final Integer ONE;
    public static final Integer MINUS_ONE;
    public static final Real POSITIVE_INFINITY;
    public static final Real NEGATIVE_INFINITY;
    public static final Real PI;
    public static final Real E;
    public static final Real NaN;
    public static final Complex I;
    public static final Complex i;
    public static final Complex INFINITY;

    protected Values() {
    }

    public static ValueFactory getInstance() {
        return Values.instantiate(GetPropertyAction.getProperty(Values.class.getName() + ".implementation", ValuesImpl.class.getName()));
    }

    public static ValueFactory getInstance(Map parameters) {
        ValueFactory factory = Values.getInstance();
        if (factory instanceof AbstractValues) {
            ((AbstractValues)factory).setParameters(parameters);
        } else if (!parameters.isEmpty()) {
            throw new UnsupportedOperationException("Passing parameters to general " + ValueFactory.class + " is not yet supported. Use Values.getInstance() for ignoring the parameter settings, or stick to an implementation extending " + AbstractValues.class);
        }
        return factory;
    }

    private static final Values instantiate(String className) {
        ClassLoader cl = Values.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            return (Values)Class.forName(className, true, cl).newInstance();
        }
        catch (ClassNotFoundException ex) {
            try {
                cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                return (Values)Class.forName(className, true, cl).newInstance();
            }
            catch (Exception ex_again) {
                throw new FactoryConfigurationError("can't instantiate Values implementation " + className, ex_again);
            }
        }
        catch (Exception ex) {
            throw new FactoryConfigurationError("can't instantiate Values implementation " + className, ex);
        }
    }

    public static final Values getDefaultInstance() {
        return defaultValueFactory;
    }

    public static final ValueFactory getDefault() {
        return defaultValueFactory;
    }

    public static final void setDefaultInstance(Values newValueFactory) {
        if (newValueFactory == null) {
            throw new NullPointerException("Can't set default value factory to " + newValueFactory);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission("orbital.math.Values.default", "write"));
        }
        defaultValueFactory = newValueFactory;
    }

    public static final void setDefault(ValueFactory newValueFactory) {
        Values.setDefaultInstance((Values)newValueFactory);
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        if (!Number.class.isAssignableFrom(clazz)) {
            return false;
        }
        return java.lang.Integer.class.equals(clazz) || Long.class.equals(clazz) || Double.class.equals(clazz) || Float.class.equals(clazz) || Byte.class.equals(clazz) || Short.class.equals(clazz);
    }

    public static Number toPrimitiveWrapper(Scalar val) {
        if (Integer.hasType.apply(val)) {
            return new java.lang.Integer(((Integer)val).intValue());
        }
        if (Real.hasType.apply(val)) {
            return new Double(((Real)val).doubleValue());
        }
        if (Rational.hasType.apply(val)) {
            return new Double(((Real)val).doubleValue());
        }
        throw new IllegalArgumentException("cannot be wrapped in a primitive wrapper type " + val.getClass());
    }

    static {
        String defaultValueFactoryClass = GetPropertyAction.getProperty(Values.class.getName() + ".default", null);
        defaultValueFactory = defaultValueFactoryClass != null ? Values.instantiate(defaultValueFactoryClass) : (Values)Values.getInstance();
        ZERO = Values.getDefault().ZERO();
        ONE = Values.getDefault().ONE();
        MINUS_ONE = Values.getDefault().MINUS_ONE();
        POSITIVE_INFINITY = Values.getDefault().POSITIVE_INFINITY();
        NEGATIVE_INFINITY = Values.getDefault().NEGATIVE_INFINITY();
        PI = Values.getDefault().PI();
        E = Values.getDefault().E();
        NaN = Values.getDefault().NaN();
        i = I = Values.getDefault().I();
        INFINITY = Values.getDefault().INFINITY();
    }
}

