/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import orbital.game.AbstractGameRules;
import orbital.game.Field;
import orbital.game.FieldChangeAdapter;
import orbital.game.FieldChangeEvent;
import orbital.game.Figure;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.Function;
import orbital.logic.functor.Functionals;
import orbital.logic.functor.Predicate;
import orbital.math.Integer;
import orbital.math.ValueFactory;
import orbital.math.Values;
import orbital.math.functional.Operations;
import orbital.robotic.Direction;
import orbital.robotic.Move;
import orbital.robotic.Moving;
import orbital.robotic.Position;
import orbital.util.Pair;
import orbital.util.SequenceIterator;
import orbital.util.Setops;

public class RhythmomachiaRules
extends AbstractGameRules {
    private static final long serialVersionUID = 7747409061002365905L;
    private final int maxDepth = 3;
    public static final int BOARD_WIDTH = 16;
    public static final int BOARD_HEIGHT = 8;
    public static final int BLACK = 1;
    public static final int WHITE = 2;
    public static final int LEAGUES = 3;
    private static final String[] LEAGUE_DESC;
    public static final int TOWER = 1;
    public static final int CIRCLE = 2;
    public static final int TRIANGLE = 3;
    public static final int SQUARE = 4;
    public static final int FIGURES = 5;
    private static final String[] TYPE_DESC;
    public static final int MV_MOVE = 1;
    public static final int MV_BEAT = 2;
    public static final int MV_ILL = 0;
    static final Color[] leagueColor;
    static final int[] moveDistance;
    private static final String[][] _moves;
    private static final String[][] _beatDirections;
    private static Move[][] legalMoves;
    static RhythmomachiaRules curRules;
    private transient boolean[] computerPlayer;
    private boolean capturing = true;
    public static final int NO_ATTACK = 0;
    public static final int SINGLE_ATTACK = 1;
    private static final int MANY_ATTACKS = 4;
    public static final int INFINITE_ATTACKS = java.lang.Integer.MAX_VALUE;
    private int attacksBeforeMove = java.lang.Integer.MAX_VALUE;
    private int attacksAfterMove = java.lang.Integer.MAX_VALUE;
    private boolean attackInsteadOfMove = false;
    public static final int NO_DIRECT_CONFRONTATION = 0;
    public static final int NO_JOINT_DIRECT_CONFRONTATION = 1;
    public static final int JOINT_DIRECT_CONFRONTATION = 2;
    private int directConfrontation = 1;
    public static final int LEAVE_ENCIRCLED = 0;
    public static final int REMOVE_ENCIRCLED = 1;
    public static final int CAPTURE_ENCIRCLED = 2;
    private int encircled = 1;
    private static final short[][][] fieldRatings;
    private static final short[][][] fieldTypes;
    private static final short[][] fieldTower;
    private static final short[][] fieldTowerTypes;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static String createMove(String string, int n, boolean bl) {
        if (n < 2) {
            throw new IllegalArgumentException("distance " + n);
        }
        --n;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(string);
        }
        if (bl) {
            stringBuffer.append('_');
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append('*');
        }
        return stringBuffer.toString();
    }

    static final Move[] createSimplifiedMovesFor(RhythmomachiaFigure rhythmomachiaFigure, int n, RhythmomachiaField rhythmomachiaField, boolean bl) {
        boolean bl2;
        if (rhythmomachiaField == null) {
            throw new NullPointerException("no field");
        }
        if (!bl) {
            return RhythmomachiaRules.stringToMove(new String[][]{_moves[n]})[0];
        }
        int n2 = n;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (rhythmomachiaFigure.getMoveDistance() <= 0) {
            linkedList.addAll(Arrays.asList(_moves[n2]));
            bl2 = false;
        } else {
            bl2 = true;
        }
        if (!$assertionsDisabled && _beatDirections[n2].length > 8) {
            throw new AssertionError((Object)"there's only 8 directions, so we only have to try into 8 directions");
        }
        block0: for (int i = 0; i < _beatDirections[n2].length; ++i) {
            Move move = new Move(_beatDirections[n2][i]);
            Moving moving = new Moving(rhythmomachiaFigure);
            for (int j = 2; j < 18; ++j) {
                moving.move(move);
                if (!rhythmomachiaField.inRange(moving)) continue block0;
                if (rhythmomachiaField.isEmpty(moving)) {
                    if (rhythmomachiaFigure.getMoveDistance() != j) continue;
                    linkedList.add(RhythmomachiaRules.createMove(_beatDirections[n2][i], j, false));
                    bl2 = false;
                    continue;
                }
                if (rhythmomachiaFigure.getLeague() == rhythmomachiaField.getFigure(moving).getLeague()) {
                    bl2 = false;
                    continue block0;
                }
                linkedList.add(RhythmomachiaRules.createMove(_beatDirections[n2][i], j, true));
                continue block0;
            }
        }
        if (bl2 && curRules.getEncircled() > 0) {
            throw new EncircledException("Encircled " + rhythmomachiaFigure);
        }
        if (!$assertionsDisabled && linkedList.size() > _moves[n2].length + _beatDirections[n2].length) {
            throw new AssertionError((Object)"at most (number-of-directions) attacks (in at most (number-of-directions) directions)");
        }
        return RhythmomachiaRules.stringToMove(new String[][]{linkedList.toArray(new String[0])})[0];
    }

    private static final List createSimplifiedMovesFor_allAttacksNoMoves(Position position, int n, RhythmomachiaField rhythmomachiaField) {
        if (rhythmomachiaField == null) {
            throw new NullPointerException("no field");
        }
        int n2 = n;
        LinkedList<Figure> linkedList = new LinkedList<Figure>();
        if (!$assertionsDisabled && _beatDirections[n2].length > 8) {
            throw new AssertionError((Object)"there's only 8 directions, so we only have to try into 8 directions");
        }
        block0: for (int i = 0; i < _beatDirections[n2].length; ++i) {
            Move move = new Move(_beatDirections[n2][i]);
            Moving moving = new Moving(position);
            for (int j = 2; j < 18; ++j) {
                moving.move(move);
                if (!rhythmomachiaField.inRange(moving)) continue block0;
                if (rhythmomachiaField.isEmpty(moving)) continue;
                linkedList.add(rhythmomachiaField.getFigure(moving));
                continue block0;
            }
        }
        if (!$assertionsDisabled && linkedList.size() > _beatDirections[n2].length) {
            throw new AssertionError((Object)"at most (number-of-directions) attacks (in at most (number-of-directions) directions)");
        }
        return linkedList;
    }

    private static Collection getThreatsTo(Position position, RhythmomachiaField rhythmomachiaField) {
        return RhythmomachiaRules.createSimplifiedMovesFor_allAttacksNoMoves(position, 4, rhythmomachiaField);
    }

    public RhythmomachiaRules() {
        super(Game.game.getResources().getString("figures.image.prefix"), Game.game.getResources().getString("figures.image.suffix"));
        if (curRules != null) {
            throw new IllegalStateException("singleton");
        }
        curRules = this;
        this.computerPlayer = new boolean[3];
        Arrays.fill(this.computerPlayer, false);
    }

    public boolean isCapturing() {
        return this.capturing;
    }

    public void setCapturing(boolean bl) {
        this.capturing = bl;
    }

    public int getAttacksBeforeMove() {
        return this.attacksBeforeMove;
    }

    public void setAttacksBeforeMove(int n) {
        if (0 > n || n > java.lang.Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.attacksBeforeMove = n;
    }

    public int getAttacksAfterMove() {
        return this.attacksAfterMove;
    }

    public void setAttacksAfterMove(int n) {
        if (0 > n || n > java.lang.Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.attacksAfterMove = n;
    }

    public boolean isAttackInsteadOfMove() {
        return this.attackInsteadOfMove;
    }

    public void setAttackInsteadOfMove(boolean bl) {
        this.attackInsteadOfMove = bl;
    }

    public int getDirectConfrontation() {
        return this.directConfrontation;
    }

    public void setDirectConfrontation(int n) {
        if (0 > n || n > 2) {
            throw new IllegalArgumentException();
        }
        this.directConfrontation = n;
    }

    public int getEncircled() {
        return this.encircled;
    }

    public void setEncircled(int n) {
        if (0 > n || n > 2) {
            throw new IllegalArgumentException();
        }
        this.encircled = n;
    }

    boolean isAutoAttackOpportunities(RhythmomachiaField rhythmomachiaField) {
        int n = rhythmomachiaField.getTurn();
        return this.isAutoAttackOpportunities() && (this.computerPlayer[n] || Game.game.getGameboard().getField() != rhythmomachiaField);
    }

    public boolean isAutoAttackOpportunities() {
        return !(this.isAttackInsteadOfMove() || this.getAttacksAfterMove() <= 4 && this.getAttacksAfterMove() != 0 || this.getAttacksBeforeMove() <= 4 && this.getAttacksBeforeMove() != 0);
    }

    public int getLeagues() {
        return 3;
    }

    public int getFigureTypes() {
        return 5;
    }

    public Function startAIntelligence(int n, String string) {
        this.computerPlayer[n] = true;
        Function function = Computer.createUtility();
        return new Computer(3, function);
    }

    public Field startField(Component component) {
        RhythmomachiaField rhythmomachiaField = new RhythmomachiaField(16, 8);
        Dimension dimension = rhythmomachiaField.getDimension();
        this.loadAllImages(component);
        for (int i = 1; i < fieldRatings.length; ++i) {
            for (int j = 0; j < fieldRatings[i].length; ++j) {
                for (int k = 0; k < dimension.height; ++k) {
                    if (fieldTypes[i][j][k] == 0) continue;
                    Position position = i == 1 ? new Position(j, k) : new Position(dimension.width - 1 - j, dimension.height - 1 - k);
                    rhythmomachiaField.setFigure(position, this.newFigure(position.x, position.y, i, fieldTypes[i][j][k], fieldRatings[i][j][k]));
                }
            }
        }
        rhythmomachiaField.setTurn(1);
        rhythmomachiaField.addFieldChangeListener(new WinnerChecker());
        return rhythmomachiaField;
    }

    void performAllAttacks(RhythmomachiaField rhythmomachiaField, Position position, Position position2) {
        if (!this.isAutoAttackOpportunities()) {
            return;
        }
        int n = rhythmomachiaField.getTurn();
        Figure figure = rhythmomachiaField.getFigure(position2);
        rhythmomachiaField.setFigure(position2, null);
        Collection collection = RhythmomachiaRules.getThreatsTo(position, rhythmomachiaField);
        Collection collection2 = RhythmomachiaRules.getThreatsTo(position2, rhythmomachiaField);
        rhythmomachiaField.setFigure(position2, figure);
        Game.logger.log(Level.FINER, "visible through source {0} are {1}\nvisible through destination {2} are {3}", new Object[]{position, collection, position2, collection2});
        if (this.isAutoAttackOpportunities(rhythmomachiaField) && curRules.getAttacksAfterMove() > 4) {
            this.performAllAttacks(rhythmomachiaField, new SequenceIterator(new Iterator[]{collection.iterator(), collection2.iterator()}), n);
        }
        if (this.isAutoAttackOpportunities(rhythmomachiaField)) {
            rhythmomachiaField.doTurn();
        }
        if (this.isAutoAttackOpportunities(rhythmomachiaField) && curRules.getAttacksBeforeMove() > 4) {
            this.performAllAttacks(rhythmomachiaField, new SequenceIterator(new Iterator[]{collection.iterator(), collection2.iterator()}), RhythmomachiaRules.opponentLeague(n));
        }
    }

    private void performAllAttacks(RhythmomachiaField rhythmomachiaField, Iterator iterator, int n) {
        final ValueFactory valueFactory = Values.getInstance();
        Game.logger.log(Level.FINEST, "perform all attack opportunitues for {0}", RhythmomachiaRules.leagueDescription(rhythmomachiaField.getTurn()));
        while (iterator.hasNext()) {
            final RhythmomachiaFigure rhythmomachiaFigure = (RhythmomachiaFigure)iterator.next();
            if (rhythmomachiaFigure.getLeague() == n || rhythmomachiaFigure.getLeague() == 0) continue;
            if (!$assertionsDisabled && rhythmomachiaFigure.isEmpty()) {
                throw new AssertionError((Object)"empty targets are not very exciting");
            }
            try {
                Object object;
                Move[] moveArray = RhythmomachiaRules.createSimplifiedMovesFor(rhythmomachiaFigure, 4, rhythmomachiaField, true);
                RhythmomachiaFigure rhythmomachiaFigure2 = null;
                LinkedList linkedList = new LinkedList();
                for (int i = 0; i < moveArray.length; ++i) {
                    if (!moveArray[i].isBeating(moveArray[i].length() - 1)) continue;
                    object = new Moving(rhythmomachiaFigure);
                    ((Moving)object).move(moveArray[i]);
                    if (!$assertionsDisabled && !rhythmomachiaField.inRange((Point)object)) {
                        throw new AssertionError((Object)"attacks should never have moved out of the field bounds");
                    }
                    RhythmomachiaFigure rhythmomachiaFigure3 = (RhythmomachiaFigure)rhythmomachiaField.getFigure((Position)object);
                    if (!$assertionsDisabled && rhythmomachiaFigure3.isEmpty()) {
                        throw new AssertionError((Object)"empty figures are not very frightening");
                    }
                    if (!$assertionsDisabled && rhythmomachiaFigure.getLeague() == rhythmomachiaFigure3.getLeague()) {
                        throw new AssertionError((Object)"threats only come from opponents, not from allies");
                    }
                    if (!$assertionsDisabled && rhythmomachiaFigure3.getLeague() != n) {
                        throw new AssertionError((Object)("threats only come from opponents, not from allies. " + rhythmomachiaFigure + " threatened by " + rhythmomachiaFigure3));
                    }
                    rhythmomachiaFigure2 = rhythmomachiaFigure3;
                    if (!Arrays.asList(rhythmomachiaFigure3.getLegalMoves()).contains(moveArray[i])) {
                        Game.logger.log(Level.FINER, "target {0} not threatened by {1}", new Object[]{rhythmomachiaFigure, rhythmomachiaFigure3});
                        continue;
                    }
                    Game.logger.log(Level.FINER, "target {0} threatened by {1}", new Object[]{rhythmomachiaFigure, rhythmomachiaFigure3});
                    LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>(5);
                    int n2 = rhythmomachiaFigure3.getDistanceTo(rhythmomachiaFigure);
                    linkedHashSet.add(valueFactory.valueOf(0));
                    for (int j = -1; j <= 1; j += 2) {
                        linkedHashSet.add(valueFactory.valueOf(j * (rhythmomachiaFigure3.getRating() * n2)));
                        if (rhythmomachiaFigure3.getRating() % n2 != 0) continue;
                        linkedHashSet.add(valueFactory.valueOf(j * (rhythmomachiaFigure3.getRating() / n2)));
                    }
                    linkedList.add(linkedHashSet);
                }
                Collection collection = Functionals.map((Function)Operations.sum, Setops.cross(linkedList));
                if (!collection.contains(valueFactory.valueOf(rhythmomachiaFigure.getRating()))) continue;
                if (Game.logger.isLoggable(Level.FINE)) {
                    object = Functionals.map(Functionals.cross(Operations.sum, new Functionals.Catamorphism("", new BinaryFunction(){

                        public Object apply(Object object, Object object2) {
                            return "" + object + " + " + object2;
                        }
                    })), Setops.cross(linkedList));
                    Game.logger.log(Level.INFO, "found attack against {0}\n  by combining {1}", new Object[]{rhythmomachiaFigure, Setops.select(null, (Collection)object, new Predicate(){

                        public boolean apply(Object object) {
                            return ((Pair)object).A.equals(valueFactory.valueOf(rhythmomachiaFigure.getRating()));
                        }
                    })});
                }
                if (!$assertionsDisabled && rhythmomachiaFigure2 == null) {
                    throw new AssertionError((Object)"if there is an attack combination, there must also have been at least one opponent attacking (no thunderstrucks)");
                }
                rhythmomachiaFigure.tackledBy(rhythmomachiaFigure2);
                rhythmomachiaField.setFigure(rhythmomachiaFigure, rhythmomachiaFigure);
            }
            catch (EncircledException encircledException) {
                System.out.println("> " + encircledException + " is encircled target, and thus can be ignored provided that encircled pieces will be removed anyways");
            }
        }
    }

    private static int checkWinner(Field field) {
        if (!RhythmomachiaRules.leagueExists(2, field)) {
            System.out.println(RhythmomachiaRules.leagueDescription(2) + " has LOST");
            return -1;
        }
        if (!RhythmomachiaRules.leagueExists(1, field)) {
            System.out.println(RhythmomachiaRules.leagueDescription(1) + " has LOST");
            return -2;
        }
        if (RhythmomachiaRules.kingExists(2, field) == null) {
            System.out.println(RhythmomachiaRules.leagueDescription(2) + " has LOST");
            return -1;
        }
        if (RhythmomachiaRules.kingExists(1, field) == null) {
            System.out.println(RhythmomachiaRules.leagueDescription(1) + " has LOST");
            return -2;
        }
        return 0;
    }

    private static int opponentLeague(int n) {
        return n == 1 ? 2 : (n == 2 ? 1 : 0);
    }

    Figure newFigure(int n, int n2, int n3, int n4, int n5) {
        RhythmomachiaFigure rhythmomachiaFigure;
        if (n4 == 1) {
            RhythmomachiaFigure[] rhythmomachiaFigureArray = new RhythmomachiaFigure[fieldTower[n3].length];
            for (int i = 0; i < rhythmomachiaFigureArray.length; ++i) {
                rhythmomachiaFigureArray[i] = (RhythmomachiaFigure)this.newFigure(-1, -1, n3, fieldTowerTypes[n3][i], fieldTower[n3][i]);
            }
            rhythmomachiaFigure = new RhythmomachiaKing(n, n2, n3, n4, n5, rhythmomachiaFigureArray);
        } else {
            rhythmomachiaFigure = new RhythmomachiaFigure(n, n2, n3, n4, n5);
        }
        rhythmomachiaFigure.setDirection(new Direction(180));
        rhythmomachiaFigure.setLegalMoves(legalMoves[n4]);
        rhythmomachiaFigure.setImage(this.getImage(rhythmomachiaFigure));
        return rhythmomachiaFigure;
    }

    private static boolean leagueExists(int n, Field field) {
        Iterator iterator = field.iterateNonEmpty();
        while (iterator.hasNext()) {
            if (((Figure)iterator.next()).getLeague() != n) continue;
            return true;
        }
        return false;
    }

    static RhythmomachiaKing kingExists(int n, Field field) {
        Iterator iterator = field.iterateNonEmpty();
        while (iterator.hasNext()) {
            Figure figure = (Figure)iterator.next();
            if (figure.getType() == 1) {
                if (figure.getLeague() != n) continue;
                return (RhythmomachiaKing)figure;
            }
            if (!$assertionsDisabled && figure instanceof RhythmomachiaKing) {
                throw new AssertionError((Object)"towers are kings");
            }
        }
        return null;
    }

    static final String typeDescription(int n) {
        return TYPE_DESC[n];
    }

    static final String leagueDescription(int n) {
        return LEAGUE_DESC[n];
    }

    static {
        $assertionsDisabled = !RhythmomachiaRules.class.desiredAssertionStatus();
        LEAGUE_DESC = new String[]{"NOONE", "BLUE", "RED"};
        TYPE_DESC = new String[]{"EMPTY", "TOWER", "CIRCLE", "TRIANGLE", "SQUARE"};
        leagueColor = new Color[]{new Color(132, 123, 247), new Color(132, 123, 247), new Color(255, 0, 123)};
        moveDistance = new int[]{0, java.lang.Integer.MIN_VALUE, 2, 3, 4};
        _moves = new String[][]{new String[0], {"R", "F", "L", "B", "/RF/RF", "/FL/FL", "/LB/LB", "/BR/BR", "RRR", "/RF/RF/RF", "FFF", "/FL/FL/FL", "LLL", "/LB/LB/LB", "BBB", "/BR/BR/BR"}, {"R", "F", "L", "B"}, {"/RF/RF", "/FL/FL", "/LB/LB", "/BR/BR"}, {"RRR", "/RF/RF/RF", "FFF", "/FL/FL/FL", "LLL", "/LB/LB/LB", "BBB", "/BR/BR/BR"}};
        _beatDirections = new String[][]{new String[0], {"R", "/RF", "F", "/FL", "L", "/LB", "B", "/BR"}, {"R", "F", "L", "B"}, {"/RF", "/FL", "/LB", "/BR"}, {"R", "/RF", "F", "/FL", "L", "/LB", "B", "/BR"}};
        legalMoves = new Move[5][];
        String[][] stringArray = new String[5][];
        for (int i = 0; i < 5; ++i) {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.addAll(Arrays.asList(_moves[i]));
            for (int j = 2; j < 18; ++j) {
                for (int k = 0; k < _beatDirections[i].length; ++k) {
                    linkedList.add(RhythmomachiaRules.createMove(_beatDirections[i][k], j, true));
                }
            }
            Game.logger.log(Level.FINER, "The {0} legal moves for {1} are {2}", new Object[]{new java.lang.Integer(linkedList.size()), RhythmomachiaRules.typeDescription(i), linkedList});
            stringArray[i] = linkedList.toArray(new String[0]);
        }
        legalMoves = RhythmomachiaRules.stringToMove(stringArray);
        fieldRatings = new short[][][]{new short[][]{new short[0]}, new short[][]{{25, 81, 0, 0, 0, 0, 169, 289}, {15, 45, 25, 20, 42, 49, 91, 153}, {9, 6, 4, 16, 36, 64, 72, 81}, {0, 0, 2, 4, 6, 8, 0, 0}}, new short[][]{{49, 121, 0, 0, 0, 0, 225, 361}, {28, 66, 36, 30, 56, 64, 120, 190}, {16, 12, 9, 25, 49, 81, 90, 100}, {0, 0, 3, 5, 7, 9, 0, 0}}};
        fieldTypes = new short[][][]{new short[][]{new short[0]}, new short[][]{{4, 4, 0, 0, 0, 0, 4, 4}, {4, 4, 3, 3, 3, 3, 1, 4}, {3, 3, 2, 2, 2, 2, 3, 3}, {0, 0, 2, 2, 2, 2, 0, 0}}, new short[][]{{4, 4, 0, 0, 0, 0, 4, 4}, {4, 4, 3, 3, 3, 3, 4, 1}, {3, 3, 2, 2, 2, 2, 3, 3}, {0, 0, 2, 2, 2, 2, 0, 0}}};
        fieldTower = new short[][]{new short[0], {1, 4, 9, 16, 25, 36}, {16, 25, 36, 49, 64}};
        fieldTowerTypes = new short[][]{new short[0], {2, 2, 3, 3, 4, 4}, {2, 3, 3, 4, 4}};
    }

    private static class WinnerChecker
    extends FieldChangeAdapter
    implements Serializable {
        private static final long serialVersionUID = 6704295362799983965L;

        private WinnerChecker() {
        }

        public void stateChanged(FieldChangeEvent fieldChangeEvent) {
            if (fieldChangeEvent.getType() == 16) {
                int n;
                if (Game.game.getGamemaster().getNumberOfHumanPlayers() == 2) {
                    ((RhythmomachiaField)fieldChangeEvent.getField()).expand();
                }
                if ((n = RhythmomachiaRules.checkWinner(fieldChangeEvent.getField())) != 0) {
                    ((RhythmomachiaField)fieldChangeEvent.getField()).mygetFieldChangeMulticaster().stateChanged(new FieldChangeEvent(fieldChangeEvent.getField(), 33, new java.lang.Integer(n)));
                }
            }
        }
    }
}

